package com.biz.crm.member.admin.web.login;

import com.biz.crm.member.business.member.sdk.vo.MemberLoginVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import org.springframework.stereotype.Component;

/**
 * CRM体系的系统中，都可以使用的用户登录策略的公共方法
 *
 * @author pengxi
 */
@Component
public abstract class DefaultPerfectLoginUserDetails {

  /**
   * 完善登录信息中的用户基本信息
   *
   * @param currentUser 查询出的当前用户
   * @param loginUserDetails 登录用户信息
   */
  protected void perfectLoginUserDetails(MemberLoginVo currentUser, MemberUserDetails loginUserDetails){
    // u-企业用户，c-客户用户，terminal-终端用户，customer_employee-经销商员工用户
    loginUserDetails.setIdentityType("member");
    loginUserDetails.setUsername(currentUser.getMemberCode());
    loginUserDetails.setMemberPhone(currentUser.getMemberPhone());
    loginUserDetails.setRealName(currentUser.getMemberName());
    loginUserDetails.setAccount(currentUser.getMemberCode());
    loginUserDetails.setMemberCode(currentUser.getMemberCode());
    loginUserDetails.setUserType(currentUser.getUserType());
    loginUserDetails.setPassword("");
  }

  /**
   * 完善登录信息中的岗位组织等信息
   *
   * 一、获取当前职位，优先级顺序：
   *     1、第一优先获取用户职位关系表“是否当前职位”为是的职位
   *     2、第二优先获取用户职位关系表“是否主职位”为是的职位，如果是命中当前优先级，需要将当前职位的“是否当前职位”关系设置为“是”
   * 二、获取当前职位对应组织
   *
   * @param loginUserDetails 登录用户信息
   */
 /* protected void perfectLoginPostAndOrg(FacturerUserDetails loginUserDetails){
    List<UserPositionVo> userPositionVos = this.userPositionVoService.findByUserName(loginUserDetails.getTenantCode(), loginUserDetails.getAccount());
    if (CollectionUtils.isEmpty(userPositionVos)) {
      return;
    }
    // 一、1、取设定在数据库中的“当前岗位”
    Optional<UserPositionVo> currentFlagVo = userPositionVos.stream()
        .filter(r-> Boolean.TRUE.equals(r.getCurrentFlag()))
        .findFirst();
    if (currentFlagVo.isPresent()) {
      UserPositionVo userPositionVo = currentFlagVo.get();
      loginUserDetails.setPostCode(userPositionVo.getPositionCode());
    } else {
      // 一、2、去当前数据库中的“默认岗位”
      Optional<UserPositionVo> primaryFlagVo = userPositionVos.stream()
          .filter(r-> Boolean.TRUE.equals(r.getPrimaryFlag()))
          .findFirst();
      if (primaryFlagVo.isPresent()) {
        UserPositionVo userPositionVo = primaryFlagVo.get();
        loginUserDetails.setPostCode(userPositionVo.getPositionCode());
        // 需要设置当前职位关系“是否当前职位”为“是”
        userPositionVoService.updateCurrentFlagPosition(loginUserDetails.getAccount(), loginUserDetails.getPostCode());
      }
    }
    // 完善职位信息
    if (StringUtils.isBlank(loginUserDetails.getPostCode())) {
      return;
    }
    List<PositionVo> positionVoList = positionVoService.findByIdsOrCodes(null, Lists.newArrayList(loginUserDetails.getPostCode()));
    if (CollectionUtils.isEmpty(positionVoList)) {
      return;
    }
    PositionVo positionVo = positionVoList.get(0);
    loginUserDetails.setPostName(positionVo.getPositionName());
    if (CollectionUtils.isNotEmpty(positionVo.getRoleList())) {
      loginUserDetails.setRoleCodes(positionVo.getRoleList().toArray(new String[] {}));
    }
    // 二、
    OrgVo orgVo = this.orgPositionVoService.findByPositionCode(loginUserDetails.getPostCode());
    if (orgVo == null) {
      return;
    }
    loginUserDetails.setOrgCode(orgVo.getOrgCode());
    loginUserDetails.setOrgName(orgVo.getOrgName());
  }*/

}
