package com.biz.crm.member.admin.web.login.decision;

import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.biz.crm.member.admin.web.login.DefaultPerfectLoginUserDetails;
import com.biz.crm.member.admin.web.login.form.UserConstant;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.vo.MemberLoginVo;
import com.bizunited.nebula.common.util.Aes128Utils;
import com.bizunited.nebula.security.local.loginform.SimpleLoginFormDetails;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 手机号+验证码
 */
@Slf4j
@Component
public class DefaultPhoneAndSmsCodeStrategy extends DefaultPerfectLoginUserDetails implements AuthenticationDecisionStrategy {

  @Autowired
  private MemberInfoService memberInfoService;

  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;

  @Override
  public Integer type() {
    return DecisionTypes.PHONEANDSMSCODE.getCode();
  }

  @Override
  public UserIdentity decide(LoginDetails loginFormDetails , Integer type) {
    /*
     * 处理过程如下：
     * 1、首先通过手机号查询当前用户并检查用户有效性
     * 2、检查当前短信验证码的有效性
     * 3、填充security鉴权必要信息：tenantCode,account,password
     * 4、然后完善登录信息中的用户基本信息
     * 5、最后完善登录信息中的岗位组织等信息
     */
    SimpleLoginFormDetails loginUserDetails = (SimpleLoginFormDetails) loginFormDetails;
    String userPhone = loginUserDetails.getPhone();
    log.info("HttpServletRequest phone:{}", userPhone);
    log.info("HttpServletRequest smsVerificationCode:{}", loginUserDetails.getSmsVerificationCode());
    Validate.notBlank(userPhone, "登录手机号不能为空！");
    Validate.notBlank(loginUserDetails.getSmsVerificationCode(), "短信验证码不能为空！");
    String smsVerificationCode = Aes128Utils.decrypt(loginUserDetails.getSmsVerificationCode(), UserConstant.ENCRYPT_KEY, Aes128Utils.EncodeType.CBC, Aes128Utils.Padding.PKCS_7_PADDING);
    log.error("decrypt smsVerificationCode:{}", smsVerificationCode);
    // 获取会员信息
    // 查询会员是否存在 ,
    MemberLoginVo memberLoginVo = memberInfoService.queryMemberInfo(userPhone);
    // 2、短信验证码验证
    Boolean isAvailable = this.validitySmsCodeService.isAvailableVerificationCode(userPhone, smsVerificationCode);
    Validate.isTrue(isAvailable, "验证码过期或不正确，请重新获取！");
    MemberUserDetails memberUserDetails = new MemberUserDetails();
    memberUserDetails.setLoginType(DecisionTypes.ACCOUNTANDPASSWORD.getCode());
    //没什么卵用
    memberUserDetails.setTenantCode("default");
    super.perfectLoginUserDetails(memberLoginVo, memberUserDetails);
    loginUserDetails.setAccount(memberUserDetails.getAccount());
    // 4、封装组织 岗位 终端用户不用
//        super.perfectLoginPostAndOrg(mdmUser);
    return memberUserDetails;
  }
}
