package com.biz.crm.member.admin.web.login.decision;

import com.biz.crm.member.admin.web.login.DefaultPerfectLoginUserDetails;
import com.biz.crm.member.business.member.sdk.vo.MemberLoginVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.bizunited.nebula.security.local.loginform.SimpleLoginFormDetails;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 手机号授权登录
 */
@Component
public class DefaultWxPhoneStrategy extends DefaultPerfectLoginUserDetails implements
    AuthenticationDecisionStrategy {

  @Autowired
  private MemberInfoService memberInfoService;

  @Override
  public Integer type() {
    return DecisionTypes.PHONEANDCODE.getCode();
  }

  @Override
  public UserIdentity decide(LoginDetails loginFormDetails, Integer type) {
    /*
     * 处理过程如下：
     * 1、首先通过手机号查询当前用户并检查用户有效性
     * 2、检查登录密码是否正确
     * 3、填充security鉴权必要信息：tenantCode,account,password
     * 4、然后完善登录信息中的用户基本信息
     * 5、最后完善登录信息中的岗位组织等信息
     */
    SimpleLoginFormDetails loginUserDetails = (SimpleLoginFormDetails) loginFormDetails;
    String phone = loginUserDetails.getPhone();
    Validate.notBlank(phone, "登录手机号不能为空！");
    // 查询会员是否存在 ,
    MemberLoginVo memberLoginVo = memberInfoService.queryMemberInfo(phone);
    if (memberLoginVo == null) {
      // 创建一个游客用户
      memberLoginVo = memberInfoService.createVisitorMember(phone);
    }
    MemberUserDetails memberUserDetails = new MemberUserDetails();
    //没什么卵用
    memberUserDetails.setTenantCode("default");
    memberUserDetails.setLoginType(DecisionTypes.PHONEANDCODE.getCode());
    super.perfectLoginUserDetails(memberLoginVo, memberUserDetails);
    loginUserDetails.setAccount(memberUserDetails.getAccount());

    return memberUserDetails;
  }
}
