package com.biz.crm.member.admin.web.login.form;

import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import com.bizunited.nebula.security.sdk.loginform.LoginValidateStrategy;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

/**
 * CRM中，所支持的厂商身份用户登录，所使用的表单信息验证和转换策略</p>
 * 
 * TODO 为什么没有使用系统自带的nebula实现的SimpleLoginValidateStrategy，是因为有一个appType字段。
 * 
 * @author yinwenjie
 */
@Component
@Primary
public class SimpleLoginValidateStrategy implements LoginValidateStrategy {

  @Override
  public boolean matched(HttpServletRequest request, Integer type) {
    return type >= 1 && type <= 6;
  }

  @Override
  public LoginDetails validateAndTransform(HttpServletRequest request) {
    return new LoginFormDetails(request);
  }
}
