package com.biz.crm.member.admin.web.login.transform;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.vo.MemberLoginVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.transform.IdentityTransformStrategy;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component("MemberTransformStrategy")
@Slf4j
public class MemberTransformStrategy implements IdentityTransformStrategy {

    @Autowired(required = false)
    private MemberInfoService memberInfoService;

    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;


    @Override
    public boolean matched(String sourceIdentityType) {
        // u-企业用户，c-客户用户，terminal-终端用户，customer_employee-经销商员工用户</br>
        return StringUtils.equals("member", sourceIdentityType);
    }

    @Override
    public UserIdentity transform(String sourceIdentityType, String sourceTenantCode, String sourceAccount, JSONObject userObject) {
        MemberUserDetails convert = JsonUtils.convert(userObject, MemberUserDetails.class);
        log.info("转换信息:{},{},{}",sourceIdentityType,sourceTenantCode,sourceAccount);
        log.info("转换信息json:{}",userObject.toJSONString());
        // 获取用户
        MemberLoginVo memberLoginVo = memberInfoService.queryMemberInfo(convert.getMemberPhone());
        Validate.notNull(memberLoginVo,"会员未找到");
        String[] independencyRoles = this.simpleSecurityProperties.getIndependencyRoles();
        convert.setRoleCodes(independencyRoles);
        return convert;
    }

    @Override
    public int getOrder() {
        return 1;
    }

}
