package com.biz.crm.member.admin.web.utils;

import static jodd.net.MimeTypes.MIME_APPLICATION_JSON;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * @author zxw
 */
@Aspect
@Component
@Slf4j
public class WebLogAspect {

    @Autowired
    private LoginUserService loginUserService;

    public WebLogAspect() {
    }


    /**
     * 前置通知：
     * 1. 在执行目标方法之前执行，比如请求接口之前的登录验证;
     * 2. 在前置通知中设置请求日志信息，如开始时间，请求参数，注解内容等
     */
    @Before("@annotation(CrmLog)")
    public void doBefore(JoinPoint joinPoint) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            String contentType = request.getContentType();
            String jwt = request.getHeader("jwt");
            if (StringUtils.isNotEmpty(contentType)&&contentType.contains(MIME_APPLICATION_JSON)) {
                Class<?> clazz = joinPoint.getTarget().getClass();
                Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();
                ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
                log.info("------------------------------------------AOP日志start--------------------------------------------------------");
                log.info("[AOP日志]:类名:{}", clazz.getName());
                Optional.ofNullable(apiOperation)
                        .filter(x -> !StringUtils.isEmpty(x.value()))
                        .ifPresent(x -> log.info("[AOP日志]:apiOperation注释:{}", x.value()));
                log.info("[AOP日志]:方法名:{}", method.getName());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[AOP日志]:方法入参:{}");
                Optional.ofNullable(joinPoint.getArgs()).ifPresent(x -> {
                    for (Object arg : x) {
//                        if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse) {
//                            continue;
//                        }
                        String temp = JSONArray.toJSONString(x);
                        log.info("[AOP日志]:方法入参:{}", temp);
                        stringBuffer.append(temp);
                        stringBuffer.append("<=====>");
                    }
                });
                JSONObject loginUserJson = loginUserService.getLoginUserJson();
                log.info("[AOP日志]:用户jwt:{}", jwt);
                log.info("[AOP日志]:请求用户:{}", loginUserJson);
                log.info("------------------------------------------AOP日志end--------------------------------------------------------");
//                ThreadLocalUtil.setParameter(stringBuffer.toString());
            }
        }


    }

//    /**
//     * 返回通知：
//     * 1. 在目标方法正常结束之后执行
//     * 1. 在返回通知中补充请求日志信息，如返回时间，方法耗时，返回值，并且保存日志信息
//     *
//     * @param ret
//     * @throws Throwable
//     */
//    @AfterReturning(returning = "ret", pointcut = "webLogPointcut()")
//    public void doAfterReturning(Object ret) throws Throwable {
//    }

//    /**
//     * 异常通知：
//     * 1. 在目标方法非正常结束，发生异常或者抛出异常时执行
//     * 1. 在异常通知中设置异常信息，并将其保存
//     *
//     * @param throwable
//     */
//    @AfterThrowing(value = "webLogPointcut()", throwing = "throwable")
//    public void doAfterThrowing(Throwable throwable) {
//        // 保存异常日志记录
//        log.error("发生异常时间：{}" + LocalDateTime.now());
//        log.error("抛出异常：{}" + throwable.getMessage());
//    }
}
