package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ActivityApplyRecordService;
import com.biz.crm.member.business.member.local.service.ActivityManageService;
import com.biz.crm.member.business.member.sdk.dto.ActivityApplyRecordDto;
import com.biz.crm.member.business.member.sdk.dto.ActivityManageDto;
import com.biz.crm.member.business.member.sdk.dto.ActivityManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.ActivityApplyRecordVo;
import com.biz.crm.member.business.member.sdk.vo.ActivityManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.ActivityApplyRecordVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 报名记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 19:08
 **/

@Slf4j
@Api(tags = "报名记录")
@RestController
@RequestMapping(value = {"/v1/member/activity/apply/record"})
public class ActivityApplyRecordController {

    @Autowired
    private RedisMutexService redisMutexService;

    @Autowired
    private ActivityApplyRecordService activityApplyRecordService;
    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<ActivityApplyRecordVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                ActivityApplyRecordDto pageDto) {
        try {
            Page<ActivityApplyRecordVo> result = this.activityApplyRecordService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<ActivityApplyRecordVo> findDetailById(@RequestParam("id") String id) {
        try {
            ActivityApplyRecordVo viewpagerVo = this.activityApplyRecordService.findDetailById(id);
            return Result.ok(viewpagerVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param activityApplyRecordDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<ActivityApplyRecordVo> create(@RequestBody ActivityApplyRecordDto activityApplyRecordDto) {
        try {
            ActivityApplyRecordVo current = this.activityApplyRecordService.create(activityApplyRecordDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 小程序活动企划(重新)报名
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "小程序活动企划(重新)报名")
    @PostMapping(value = "join")
    public Result<?> join(@RequestBody ActivityApplyRecordDto dto) {
        boolean locked = false;
        try {
            Validate.isTrue(StringUtils.isNotEmpty(dto.getOperateId()),"报名操作id不能为空！");
            locked = redisMutexService.tryLock(dto.getOperateId(), TimeUnit.SECONDS, 5);
            Validate.isTrue(locked,"请勿重复点击！");
            this.activityApplyRecordService.join(dto);
            return Result.ok("OK");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }finally {
            if (locked) {
                redisMutexService.unlock(dto.getOperateId());
            }
        }
    }

    @ApiOperation(value = "获取报名操作标识(防重复点击)")
    @PostMapping("/getId")
    public Result<String> getId() {
        Result<String> result = new Result<>();
        result.setResult(this.activityApplyRecordService.getId());
        return result;
    }

    /**
     * (小程序活动企划签到)
     *
     * @param activityApplyRecordDto
     * @return
     */
    @ApiOperation(value = "(小程序活动企划签到)")
    @GetMapping(value = "sign")
    public Result<?> sign(ActivityApplyRecordDto activityApplyRecordDto) {
        try {
            this.activityApplyRecordService.sign(activityApplyRecordDto);
            return Result.ok("OK");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<ActivityApplyRecordVo> update(@RequestBody ActivityApplyRecordDto activityApplyRecordDto) {
        try {
            ActivityApplyRecordVo current = this.activityApplyRecordService.updateForm(activityApplyRecordDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 通过审批
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "通过审批")
    @PatchMapping(value = "/approvalPass")
    public Result approvalPass(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.approvalPass(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 驳回审批
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "通过审批")
    @PatchMapping(value = "/approvalReturn")
    public Result approvalReturn(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.approvalReturn(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    
}
