package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ActivityManageService;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.dto.ActivityManageDto;
import com.biz.crm.member.business.member.sdk.dto.ActivityManagePageDto;
import com.biz.crm.member.business.member.sdk.dto.ViewpagerDto;
import com.biz.crm.member.business.member.sdk.vo.ActivityManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.ActivityManageVo;
import com.biz.crm.member.business.member.sdk.vo.ActivityManageVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 14:17
 **/
@Slf4j
@Api(tags = "活动管理")
@RestController
@RequestMapping(value = {"/v1/member/activity"})
public class ActivityManageController extends BaseController {


    @Autowired
    private ActivityManageService activityManageService;
    /**
     * 后台查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "后台查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<ActivityManagePageVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                           ActivityManagePageDto pageDto) {
        try {
            Page<ActivityManagePageVo> result = this.activityManageService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 小程序查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "小程序查询分页列表")
    @GetMapping(value = {"/findByConditionsByApplet"})
    public Result<Page<ActivityManagePageVo>> findByConditionsByApplet(@PageableDefault(50) Pageable pageable,
                                                           ActivityManagePageDto pageDto) {
        try {
            Page<ActivityManagePageVo> result = this.activityManageService.findByConditionsByApplet(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<ActivityManageVo> findDetailById(@RequestParam("id") String id,@RequestParam(value = "fromPhone",required = false) String fromPhone) {
        try {
            ActivityManageVo viewpagerVo = this.activityManageService.findDetailById(id,fromPhone);
            return Result.ok(viewpagerVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param activityManageDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<ActivityManageVo> create(@RequestBody ActivityManageDto activityManageDto) {
        try {
            ActivityManageVo current = this.activityManageService.create(activityManageDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<ActivityManageVo> update(@RequestBody ActivityManageDto activityManageDto) {
        try {
            ActivityManageVo current = this.activityManageService.updateForm(activityManageDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.activityManageService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.activityManageService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.activityManageService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 生成二维码
     *
     * @param code
     * @return
     */
    @ApiOperation(value = "生成二维码")
    @GetMapping(value = "/buildBarCode")
    public Result buildBarCode(@RequestParam("code") String code) {
        try {
            this.activityManageService.buildBarCode(code);
            return Result.ok("生成成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
