package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.local.service.BenefitsManageOrgService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManageOrgPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 权益管理-区域有效期配置(BenefitsManageOrg)表控制层
 *
 * @author zouhs
 * @date 2023-06-12 12:39:29
 */
@Slf4j
@Api(tags = "权益管理-区域有效期配置")
@RestController
@RequestMapping(value = {"/v1/benefitsManageOrg/benefitsManageOrg"})
public class BenefitsManageOrgController {

  @Autowired(required = false)
  private BenefitsManageOrgService benefitsManageOrgService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<BenefitsManageOrgVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      BenefitsManageOrgPaginationDto paginationDto) {
    try {
      Page<BenefitsManageOrgVo> result = this.benefitsManageOrgService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<BenefitsManageOrgVo> findDetailById(@RequestParam("id") String id) {
    try {
      BenefitsManageOrgVo benefitsManageOrgVo = this.benefitsManageOrgService.findDetailById(id);
      return Result.ok(benefitsManageOrgVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param benefitsManageOrgVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<BenefitsManageOrgVo> create(@RequestBody BenefitsManageOrgVo benefitsManageOrgVo) {
    try {
      BenefitsManageOrgVo current = this.benefitsManageOrgService.create(benefitsManageOrgVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param benefitsManageOrgVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<BenefitsManageOrgVo> update(@RequestBody BenefitsManageOrgVo benefitsManageOrgVo) {
    try {
      BenefitsManageOrgVo current = this.benefitsManageOrgService.update(benefitsManageOrgVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.benefitsManageOrgService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.benefitsManageOrgService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.benefitsManageOrgService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
