package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.MemberInfoBenefitsService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/7/4 10:25
 * @description
 */
@Api(tags = "权益记录管理")
@RestController
@RequestMapping("/v1/benefits/record")
@Slf4j
public class BenefitsRecordController {
  @Autowired
  private MemberInfoBenefitsService memberInfoBenefitsService;

  @ApiOperation("分页获取权益记录")
  @GetMapping("/page/benefits/record")
  public Result<Page<MemberInfoBenefitsVo>> pageBenefitsRecord(@PageableDefault(50) Pageable pageable,
      BenefitsRecordPaginationDto dto){
    try {
      Page<MemberInfoBenefitsVo> result = memberInfoBenefitsService.pageByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
