package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.BenefitsTransferRecord;
import com.biz.crm.member.business.member.local.service.BenefitsTransferRecordService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.BenefitsTransferRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsTransferRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hupan
 * @date 2023/6/29 15:36
 */
@Slf4j
@Api(tags = "权益转移记录")
@RestController
@RequestMapping(value = {"/v1/benefitsTransferRecord/benefitsTransferRecord"})
public class BenefitsTransferRecordController {

  @Autowired(required = false)
  private BenefitsTransferRecordService benefitsTransferRecordService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<BenefitsTransferRecordVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      BenefitsTransferRecordPaginationDto paginationDto) {
    try {
      Page<BenefitsTransferRecordVo> result = this.benefitsTransferRecordService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<BenefitsTransferRecordVo> findDetailById(@RequestParam("id") String id) {
    try {
      BenefitsTransferRecordVo benefitsTransferRecordVo = this.benefitsTransferRecordService.findDetailById(id);
      return Result.ok(benefitsTransferRecordVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
