package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.CardProductService;
import com.biz.crm.member.business.member.local.service.HolidayService;
import com.biz.crm.member.business.member.sdk.dto.CardProductDto;
import com.biz.crm.member.business.member.sdk.dto.HolidayDto;
import com.biz.crm.member.business.member.sdk.vo.CardProductVo;
import com.biz.crm.member.business.member.sdk.vo.HolidayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 名片产品
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 11:00
 **/
@Slf4j
@Api(tags = "名片产品")
@RestController
@RequestMapping(value = {"/v1/member/cardProduct"})
public class CardProductController {

    @Autowired
    private CardProductService cardProductService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<CardProductVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                        CardProductDto pageDto) {
        try {
            Page<CardProductVo> result = this.cardProductService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<CardProductVo> findDetailById(@RequestParam("id") String id) {
        try {
            CardProductVo cardProductVo = this.cardProductService.findDetailById(id);
            return Result.ok(cardProductVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param cardProductDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<CardProductVo> create(@RequestBody CardProductDto cardProductDto) {
        try {
            CardProductVo current = this.cardProductService.create(cardProductDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param cardProductDto
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<CardProductVo> update(@RequestBody CardProductDto cardProductDto) {
        try {
            CardProductVo current = this.cardProductService.update(cardProductDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.cardProductService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.cardProductService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.cardProductService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }



}
