package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.ChoiceNessCategory;
import com.biz.crm.member.business.member.local.service.ChoiceNessCategoryService;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.ChoiceNessCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 17:00
 * @description 精选分类管理(ChoiceNessCategory)表控制层
 */
@Slf4j
@Api(tags = "精选分类管理")
@RestController
@RequestMapping("/v1/choice/ness/category")
public class ChoiceNessCategoryController {

  @Autowired
  private ChoiceNessCategoryService choiceNessCategoryService;

  @ApiOperation("新增")
  @PostMapping
  public Result<ChoiceNessCategoryVo> createChoiceNessCategory(
      @RequestBody ChoiceNessCategoryDto dto) {
    try {
      ChoiceNessCategoryVo result = choiceNessCategoryService.createChoiceNessCategory(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("编辑")
  @PutMapping
  public Result<ChoiceNessCategoryVo> update(@RequestBody ChoiceNessCategoryDto dto) {
    try {
      ChoiceNessCategoryVo result = choiceNessCategoryService.updateChoiceNessCategory(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("查看单个精选分类")
  @GetMapping("/{id}")
  public Result<ChoiceNessCategoryVo> getChoiceNessCategory(@PathVariable("id") String id) {
    try {
      ChoiceNessCategoryVo result = choiceNessCategoryService.getChoiceNessCategoryById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("分页获取精选分类信息")
  @GetMapping("/page")
  public Result<Page<ChoiceNessCategoryVo>> pageCategory(@PageableDefault(50) Pageable pageable,
      ChoiceNessCategoryPaginationDto dto) {
    try {
      Page<ChoiceNessCategoryVo> result = this.choiceNessCategoryService
          .pageChoiceNessCategory(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("启用")
  @PatchMapping("/turn/on")
  public Result turnOnCategory(@RequestBody List<String> ids){
    try {
      this.choiceNessCategoryService.turnOnCategory(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("禁用")
  @PatchMapping("/turn/off")
  public Result turnOffCategory(@RequestBody List<String> ids){
    try {
      this.choiceNessCategoryService.turnOffCategory(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(),e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("删除")
  @DeleteMapping
  public Result logicDeleteCategory(@RequestParam("ids") List<String> ids){
    try {
      this.choiceNessCategoryService.logicDeleteCategory(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
