package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismRespondentService;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismTopicService;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismRespondentPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismTopicPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hupan
 * @date 2023/6/19 12:55
 */
@Slf4j
@Api(tags = "文旅答题-答题记录")
@RestController
@RequestMapping(value = {"/v1/CulturalAndTourismRespondent/CulturalAndTourismRespondent"})
public class CulturalAndTourismRespondentController {

  @Autowired(required = false)
  private CulturalAndTourismRespondentService culturalAndTourismRespondentService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<CulturalAndTourismRespondentVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      CulturalAndTourismRespondentPaginationDto paginationDto) {
    try {
      Page<CulturalAndTourismRespondentVo> result = this.culturalAndTourismRespondentService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
