package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismTopicService;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismTopicPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hupan
 * @date 2023/6/19 12:55
 */
@Slf4j
@Api(tags = "文旅答题-题目管理")
@RestController
@RequestMapping(value = {"/v1/CulturalAndTourismTopic/CulturalAndTourismTopic"})
public class CulturalAndTourismTopicController {

  @Autowired(required = false)
  private CulturalAndTourismTopicService culturalAndTourismTopicService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<CulturalAndTourismTopicVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      CulturalAndTourismTopicPaginationDto paginationDto) {
    try {
      Page<CulturalAndTourismTopicVo> result = this.culturalAndTourismTopicService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param culturalAndTourismTopicVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<CulturalAndTourismTopicVo> create(@RequestBody CulturalAndTourismTopicVo culturalAndTourismTopicVo) {
    try {
      CulturalAndTourismTopicVo current = this.culturalAndTourismTopicService.create(culturalAndTourismTopicVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<CulturalAndTourismTopicVo> findDetailById(@RequestParam("id") String id) {
    try {
      CulturalAndTourismTopicVo culturalAndTourismTopicVo = this.culturalAndTourismTopicService.findDetailById(id);
      return Result.ok(culturalAndTourismTopicVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param culturalAndTourismTopicVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<CulturalAndTourismTopicVo> update(@RequestBody CulturalAndTourismTopicVo culturalAndTourismTopicVo) {
    try {
      CulturalAndTourismTopicVo current = this.culturalAndTourismTopicService.update(culturalAndTourismTopicVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.culturalAndTourismTopicService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.culturalAndTourismTopicService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.culturalAndTourismTopicService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
