package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.DeliveryPermissionManageService;
import com.biz.crm.member.business.member.sdk.dto.DeliveryPermissionManageDto;
import com.biz.crm.member.business.member.sdk.vo.DeliveryPermissionManageVo;
import com.biz.crm.member.business.member.sdk.vo.IndustryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 组织配送权限(DeliveryPermissionManage)表控制层
 *
 * @author hupan
 * @date 2023/6/14 13:46
 */
@Slf4j
@Api(tags = "组织配送权限管理")
@RestController
@RequestMapping(value = {"/v1/DeliveryPermissionManage/DeliveryPermissionManage"})
public class DeliveryPermissionManageController {

  @Autowired(required = false)
  private DeliveryPermissionManageService deliveryPermissionManageService;

  @ApiOperation("查询所有的配送权限")
  @GetMapping("/findByConditions")
  public Result<Page<DeliveryPermissionManageVo>> findByConditions(
      @PageableDefault(50)Pageable pageable,DeliveryPermissionManageDto dto){
    try {
      Page<DeliveryPermissionManageVo> vos = deliveryPermissionManageService
          .findByConditions(pageable,dto);
      return Result.ok(vos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("增加批量配送权限")
  @PostMapping("/addBatch")
  public Result addBatch(@RequestBody List<DeliveryPermissionManageDto> list){
    try {
      deliveryPermissionManageService.addBatch(list);
      return Result.ok("添加成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("批量关闭配送权限")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids){
    try {
      deliveryPermissionManageService.disableBatch(ids);
      return Result.ok("关闭成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("批量开启配送权限")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids){
    try {
      deliveryPermissionManageService.enableBatch(ids);
      return Result.ok("开启成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
