package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.Discuss;
import com.biz.crm.member.business.member.local.service.DiscussService;
import com.biz.crm.member.business.member.sdk.dto.DiscussDto;
import com.biz.crm.member.business.member.sdk.dto.DiscussPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 14:08
 * @description 评论管理(Discuss)表控制层
 */
@Api(tags = "评论管理")
@RestController
@Slf4j
@RequestMapping("/v1/discuss/manage")
public class DiscussController {

  // 精选评论
  private final Integer CHOICE_DISCUSS = 1;
  // 不是精选评论
  private final Integer NO_CHOICE_DISCUSS = 0;

  @Autowired
  private DiscussService discussService;

  @ApiOperation("新增")
  @PostMapping
  public Result<DiscussVo> createDiscuss(@RequestBody DiscussDto dto){
    try {
      DiscussVo result = this.discussService.createDiscuss(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("逻辑删除")
  @DeleteMapping
  public Result logicDeleteByIds(@RequestParam("ids")List<String> ids){
    try {
      this.discussService.logicDeleteByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("批量操作审核状态==>通过||驳回||反审批")
  @PatchMapping("/batch/check/status")
  public Result batchApprove(@RequestBody List<String> ids, String checkStatus){
    try {
      this.discussService.batchModifyCheckStatus(ids, checkStatus);
      return Result.ok("修改审批状态成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @ApiOperation("启用")
  @PatchMapping("/turn/on")
  public Result turnOnDiscuss(@RequestBody List<String> ids){
    try {
      this.discussService.turnOnDiscuss(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("禁用")
  @PatchMapping("/turn/off")
  public Result turnOffDiscuss(@RequestBody List<String> ids){
    try {
      this.discussService.turnOffDiscuss(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("精选")
  @PatchMapping("/choice/discuss")
  public Result batchModifyChoiceDiscuss(@RequestBody List<String> ids){
    try {
      this.discussService.batchModifyChoiceDiscuss(ids, this.CHOICE_DISCUSS);
      return Result.ok("精选成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("取消精选")
  @PatchMapping("/cancel/choice/discuss")
  public Result batchCancelChoiceDiscuss(@RequestBody List<String> ids){
    try {
      this.discussService.batchModifyChoiceDiscuss(ids, this.NO_CHOICE_DISCUSS);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  // todo 导出待定

  @ApiOperation("分页获取评论")
  @GetMapping("/page")
  public Result<Page<DiscussVo>> pageResult(@PageableDefault(50) Pageable pageable, DiscussPaginationDto dto){
    try {
      Page<DiscussVo> result = this.discussService.pageDiscuss(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
