package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.local.service.DummyOrderService;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 虚拟订单(DummyOrder)表控制层
 *
 * @author zouhs
 * @date 2023-06-14 15:01:00
 */
@Slf4j
@Api(tags = "虚拟订单")
@RestController
@RequestMapping(value = {"/v1/dummyOrder/dummyOrder"})
public class DummyOrderController {

  @Autowired(required = false)
  private DummyOrderService dummyOrderService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<DummyOrderVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      DummyOrderPaginationDto paginationDto) {
    try {
      Page<DummyOrderVo> result = this.dummyOrderService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 用户信息
   *
   * @param orderCode
   * @return
   */
  @ApiOperation(value = "用户信息")
  @GetMapping(value = {"/userInfoList"})
  public Result<List<DummyOrderUserVo>> userInfoList(@RequestParam("orderCode") String orderCode) {
    try {
      List<DummyOrderUserVo> result = this.dummyOrderService.userInfoList(orderCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量核销 -也可以单核销
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "批量核销 -也可以单核销")
  @PostMapping(value = {"/batchWriteOff"})
  public Result batchWriteOff(@RequestBody List<String> ids) {
    try {
      this.dummyOrderService.batchWriteOff(ids);
      return Result.ok("核销成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 结算 - 提交工作流
   *
   * @param dummyOrderVo
   * @return
   */
  @ApiOperation(value = "结算 - 提交工作流")
  @PostMapping("/settleSubmit")
  public Result settleSubmit(@RequestBody DummyOrderVo dummyOrderVo) {
    try {
      this.dummyOrderService.settleSubmit(dummyOrderVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<DummyOrderVo> findDetailById(@RequestParam("id") String id) {
    try {
      DummyOrderVo dummyOrderVo = this.dummyOrderService.findDetailById(id);
      return Result.ok(dummyOrderVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param dummyOrderVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<DummyOrderVo> create(@RequestBody DummyOrderVo dummyOrderVo) {
    try {
      DummyOrderVo current = this.dummyOrderService.create(dummyOrderVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param dummyOrderVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<DummyOrderVo> update(@RequestBody DummyOrderVo dummyOrderVo) {
    try {
      DummyOrderVo current = this.dummyOrderService.update(dummyOrderVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.dummyOrderService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.dummyOrderService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.dummyOrderService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
