package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderApplyUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.local.service.DummyOrderUserService;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderUserPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 虚拟订单用户信息(DummyOrderUser)表控制层
 *
 * @author zouhs
 * @date 2023-06-14 15:01:25
 */
@Slf4j
@Api(tags = "虚拟订单用户信息")
@RestController
@RequestMapping(value = {"/v1/dummyOrderUser/dummyOrderUser"})
public class DummyOrderUserController {

  @Autowired(required = false)
  private DummyOrderUserService dummyOrderUserService;


  /**
   * 用户报名记录
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "用户报名记录")
  @GetMapping(value = {"/findDummyOrderUserApplyByConditions"})
  public Result<Page<DummyOrderApplyUserVo>> findDummyOrderUserApplyByConditions(@PageableDefault(50) Pageable pageable,
      DummyOrderUserPaginationDto paginationDto) {
    try {
      Page<DummyOrderApplyUserVo> result = this.dummyOrderUserService.findDummyOrderUserApplyByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<DummyOrderUserVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      DummyOrderUserPaginationDto paginationDto) {
    try {
      Page<DummyOrderUserVo> result = this.dummyOrderUserService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<DummyOrderUserVo> findDetailById(@RequestParam("id") String id) {
    try {
      DummyOrderUserVo dummyOrderUserVo = this.dummyOrderUserService.findDetailById(id);
      return Result.ok(dummyOrderUserVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param dummyOrderUserVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<DummyOrderUserVo> create(@RequestBody DummyOrderUserVo dummyOrderUserVo) {
    try {
      DummyOrderUserVo current = this.dummyOrderUserService.create(dummyOrderUserVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param dummyOrderUserVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<DummyOrderUserVo> update(@RequestBody DummyOrderUserVo dummyOrderUserVo) {
    try {
      DummyOrderUserVo current = this.dummyOrderUserService.update(dummyOrderUserVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.dummyOrderUserService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.dummyOrderUserService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.dummyOrderUserService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
