package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.HolidayService;
import com.biz.crm.member.business.member.local.service.IndustryService;
import com.biz.crm.member.business.member.sdk.dto.HolidayDto;
import com.biz.crm.member.business.member.sdk.dto.HolidayDto;
import com.biz.crm.member.business.member.sdk.dto.IndustryPageDto;
import com.biz.crm.member.business.member.sdk.vo.HolidayVo;
import com.biz.crm.member.business.member.sdk.vo.IndustryPageVo;
import com.biz.crm.member.business.member.sdk.vo.HolidayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 节日管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 17:48
 **/
@Slf4j
@Api(tags = "节日管理")
@RestController
@RequestMapping(value = {"/v1/member/holiday"})
public class HolidayController {

    @Autowired
    private HolidayService holidayService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<HolidayVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                    HolidayDto pageDto) {
        try {
            Page<HolidayVo> result = this.holidayService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<HolidayVo> findDetailById(@RequestParam("id") String id) {
        try {
            HolidayVo industryVo = this.holidayService.findDetailById(id);
            return Result.ok(industryVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param holidayDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<HolidayVo> create(@RequestBody HolidayDto holidayDto) {
        try {
            HolidayVo current = this.holidayService.create(holidayDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param holidayDto
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<HolidayVo> update(@RequestBody HolidayDto holidayDto) {
        try {
            HolidayVo current = this.holidayService.update(holidayDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.holidayService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.holidayService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.holidayService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
