package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.HolidayIntegralRecordService;
import com.biz.crm.member.business.member.sdk.dto.HolidayIntegralRecordDto;
import com.biz.crm.member.business.member.sdk.vo.HolidayIntegralRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 节日获取积分记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 12:43
 **/
@Slf4j
@Api(tags = "节日获取积分记录")
@RestController
@RequestMapping(value = {"/v1/member/holiday/record"})
public class HolidayIntegralRecordController {

    @Autowired
    private HolidayIntegralRecordService holidayIntegralRecordService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<HolidayIntegralRecordVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                  HolidayIntegralRecordDto pageDto) {
        try {
            Page<HolidayIntegralRecordVo> result = this.holidayIntegralRecordService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
