package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.InfoCategoryService;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.persistence.Access;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 11:04
 * @description 资讯分类管理(InfoCategory)表控制层
 */
@Slf4j
@Api(tags = "资讯分类管理")
@RestController
@RequestMapping(value = "/v1/infoCategory/manage")
public class InfoCategoryController {

  @Autowired
  private InfoCategoryService infoCategoryService;

  /**
   * 新增一个资讯分类
   * @param infoCategoryDto
   * @return
   */
  @ApiOperation("新增")
  @PostMapping
  public Result<InfoCategoryVo> create(@RequestBody InfoCategoryDto infoCategoryDto){
    try {
      InfoCategoryVo result = infoCategoryService.createInfoCategory(infoCategoryDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 编辑资讯分类信息
   * @param infoCategoryDto
   * @return
   */
  @ApiOperation("编辑")
  @PatchMapping
  public Result<InfoCategoryVo> updateInfoCategory(@RequestBody InfoCategoryDto infoCategoryDto){
    try {
      InfoCategoryVo result = infoCategoryService.updateInfoCategory(infoCategoryDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分页获取资讯管理信息
   * @param pageable 分页信息
   * @param paginationDto 查询条件
   * @return
   */
  @ApiOperation("分页获取资讯管理信息")
  @GetMapping("/page")
  public Result<Page<InfoCategoryVo>> pageInfoCategory(@PageableDefault(50) Pageable pageable, InfoCategoryPaginationDto paginationDto){
    try {
      Page<InfoCategoryVo> result = infoCategoryService.pageInfoCategory(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id获取资讯分类信息
   * @param id 资讯分类id
   * @return
   */
  @ApiOperation("根据id获取资讯分类信息")
  @GetMapping("/{infoCategoryId}")
  public Result<InfoCategoryVo> getInfoCategoryById(@PathVariable("infoCategoryId") String id){
    try {
      InfoCategoryVo result = infoCategoryService.getInfoCategoryById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id集合批量启用资讯分类状态
   * @param ids
   * @return
   */
  @ApiOperation("启用")
  @PatchMapping("/turn/on")
  public Result turnOnInfoCategory(@RequestBody List<String> ids){
    try {
      infoCategoryService.turnOnInfoCategory(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id集合批量禁用资讯分类状态
   * @param ids
   * @return
   */
  @ApiOperation("禁用")
  @PatchMapping("/turn/off")
  public Result turnOffInfoCategory(@RequestBody List<String> ids){
    try {
      infoCategoryService.turnOffInfoCategory(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id集合批量逻辑删除资讯分类
   * @param ids
   * @return
   */
  @ApiOperation("逻辑删除")
  @DeleteMapping
  public Result logicDeleteInfoCategory(@RequestParam("ids") List<String> ids){
    try {
      infoCategoryService.logicDeleteInfoCategory(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
