package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.InfoManageService;
import com.biz.crm.member.business.member.local.service.InfoUpvoteService;
import com.biz.crm.member.business.member.sdk.dto.InfoManageDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePubDto;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 10:12
 * @description 资讯管理(InfoManage)表控制层
 */
@Api(tags = "资讯管理")
@Slf4j
@RestController
@RequestMapping("/v1/info/manage")
public class InfoManageController {

  @Autowired
  private InfoManageService infoManageService;

  @Autowired
  private InfoUpvoteService infoUpvoteService;

  @ApiOperation("新增富文本资讯")
  @PostMapping("/rich/text")
  public Result<InfoManageVo> createRichText(@RequestBody InfoManageDto dto){
    try {
      InfoManageVo result = infoManageService.createRichText(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PostMapping("/pub/account")
  @ApiOperation("新增公众号资讯")
  public Result<InfoManageVo> createPubAccount(@RequestBody InfoManagePubDto dto){
    try {
      InfoManageVo result = infoManageService.createPubAccount(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("逻辑删除")
  @DeleteMapping("/delete")
  public Result logicDeleteInfoByIds(@RequestParam("ids") List<String> ids){
    try {
      infoManageService.logicDeleteInfoByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("修改资讯")
  @PutMapping("/modify")
  public Result<InfoManageVo> modifyInfo(@RequestBody InfoManageDto dto){
    try {
      InfoManageVo result = infoManageService.updateInfo(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("启用")
  @PatchMapping("/turn/on")
  public Result turnOnInfo(@RequestBody List<String> ids){
    try {
      infoManageService.turnOnInfoByIds(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("禁用")
  @PatchMapping("/turn/off")
  public Result turnOffInfo(@RequestBody List<String> ids){
    try {
      infoManageService.turnOffByIds(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("分页获取资讯信息")
  @GetMapping("/page")
  public Result<Page<InfoManageVo>> pageResult(@PageableDefault(50) Pageable pageable,
      InfoManagePaginationDto dto){
    try {
      Page<InfoManageVo> result = infoManageService.pageInfo(pageable, dto);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @ApiOperation("导出 待定")
  @GetMapping("/export")
  public Result exportByIds(List<String> ids){
    // todo... 根据id集合导出资讯||根据分页查询条件导出资讯
    return null;
  }


}
