package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.LabelCategory;
import com.biz.crm.member.business.member.local.service.LabelCategoryService;
import com.biz.crm.member.business.member.sdk.dto.LabelCategoryDto;
import com.biz.crm.member.business.member.sdk.vo.LabelCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 标签种类管理(LabelCategory)表控制层
 *
 * @author hupan
 * @date 2023-06-13
 */
@Slf4j
@Api(tags = "标签分类管理")
@RestController
@RequestMapping(value = {"/v1/label/labelCategpryManage"})
public class LabelCategoryController {

  @Resource
  LabelCategoryService categoryService;

  @ApiOperation(value = "查询标签分类的分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<LabelCategoryVo>> findByConditions(
      @PageableDefault(50)Pageable pageable,
      LabelCategoryVo vo) {
    try {
      Page<LabelCategoryVo> result = this.categoryService.findByConditions(pageable,vo);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "会员编辑标签 - 查询所有标签分类")
  @GetMapping("/labelCategpryAll")
  public Result<List<LabelCategoryVo>> labelCategoryAll() {
    try {
      List<LabelCategoryVo> result = this.categoryService.labelCategoryAll();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "会员编辑标签 - 查询所有标签")
  @GetMapping("/labelAll")
  public Result<List<LabelCategoryVo>> labelAll(LabelCategoryVo vo) {
    try {
      List<LabelCategoryVo> result = this.categoryService.labelAll(vo);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("")
  public Result create(@RequestBody LabelCategoryVo labelCategoryVo) {
    try {
      categoryService.create(labelCategoryVo);
      return Result.ok("添加成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "编辑")
  @PatchMapping(value = "")
  public Result update(@RequestBody LabelCategoryVo labelCategoryVo) {
    try {
      categoryService.update(labelCategoryVo);
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.categoryService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.categoryService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.categoryService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分类标签排序上移
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "标签排序上移")
  @GetMapping("/up")
  public Result up(@RequestParam("id") String id) {
    try {
      this.categoryService.updateSort(id,-1);
      return Result.ok("上移成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分类标签排序下移
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "标签排序下移")
  @GetMapping("/down")
  public Result down(@RequestParam("id") String id) {
    try {
      this.categoryService.updateSort(id,1);
      return Result.ok("下移成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 标签分类的下拉框
   */
//  @ApiOperation(value = "标签分类的下拉框")
//  @GetMapping("/comboBox")
  public Result<List<LabelCategoryVo>> findComboBox() {
    try {
      List<LabelCategoryVo> result = this.categoryService.findByConditions();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
