package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.LabelService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.LabelDetailDto;
import com.biz.crm.member.business.member.sdk.dto.LabelPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.LabelDetailVo;
import com.biz.crm.member.business.member.sdk.vo.LabelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 标签管理控制层
 *
 * @author hupan
 * @date 2023-06-13
 */
@Slf4j
@Api(tags = "标签管理")
@RestController
@RequestMapping(value = {"/v1/label/labelManage"})
public class LabelController {

  @Resource
  private LabelService labelService;

  @ApiOperation("查询标签分页")
  @GetMapping("/findByConditions")
  public Result<Page<LabelVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      LabelPaginationDto labelPaginationDto){
    try {
      Page<LabelVo> lists = labelService.findByConditions(pageable, labelPaginationDto);
      return Result.ok(lists);
    }catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(("新增"))
  @PostMapping("")
  public Result create(@RequestBody LabelVo labelVo){
    try {
      labelService.create(labelVo);
      return Result.ok("添加成功");
    }catch (RuntimeException e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(("编辑"))
  @PatchMapping(value = "")
  public Result update(@RequestBody LabelVo labelVo){
    try {
      labelService.update(labelVo);
      return Result.ok("编辑成功");
    }catch (RuntimeException e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value="查看")
  @GetMapping(value={"/findDetailById"})
  public Result findDetailById(@RequestParam("id") String id){
    try {
      LabelVo labelVo = labelService.findDetailById(id);
      return Result.ok(labelVo);
    }catch (RuntimeException e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "批量启用标签")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.labelService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "批量禁用标签")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.labelService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.labelService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
