package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.sdk.dto.LevelManagePaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 等级管理(LevelManage)表控制层
 *
 * @author zouhs
 * @date 2023-06-13 09:51:36
 */
@Slf4j
@Api(tags = "等级管理")
@RestController
@RequestMapping(value = {"/v1/levelManage/levelManage"})
public class LevelManageController {

  @Autowired(required = false)
  private LevelManageService levelManageService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<LevelManageVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      LevelManagePaginationDto paginationDto) {
    try {
      Page<LevelManageVo> result = this.levelManageService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 所有等级
   *
   * @return
   */
  @ApiOperation(value = "所有等级")
  @GetMapping(value = {"/allList"})
  public Result<List<LevelManageVo>> allList() {
    try {
      List<LevelManageVo> result = this.levelManageService.allList();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<LevelManageVo> findDetailById(@RequestParam("id") String id) {
    try {
      LevelManageVo levelManageVo = this.levelManageService.findDetailById(id);
      return Result.ok(levelManageVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param levelManageVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<LevelManageVo> create(@RequestBody LevelManageVo levelManageVo) {
    try {
      LevelManageVo current = this.levelManageService.create(levelManageVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param levelManageVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<LevelManageVo> update(@RequestBody LevelManageVo levelManageVo) {
    try {
      LevelManageVo current = this.levelManageService.update(levelManageVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.levelManageService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.levelManageService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.levelManageService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
