package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.local.service.MemberInfoAssetsService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoAssetsPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员资产(MemberInfoAssets)表控制层
 *
 * @author zouhs
 * @date 2023-06-19 14:32:53
 */
@Slf4j
@Api(tags = "会员资产")
@RestController
@RequestMapping(value = {"/v1/memberInfoAssets/memberInfoAssets"})
public class MemberInfoAssetsController {

  @Autowired(required = false)
  private MemberInfoAssetsService memberInfoAssetsService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoAssetsVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      MemberInfoAssetsPaginationDto paginationDto) {
    try {
      Page<MemberInfoAssetsVo> result = this.memberInfoAssetsService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<MemberInfoAssetsVo> findDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoAssetsVo memberInfoAssetsVo = this.memberInfoAssetsService.findDetailById(id);
      return Result.ok(memberInfoAssetsVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param memberInfoAssetsVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<MemberInfoAssetsVo> create(@RequestBody MemberInfoAssetsVo memberInfoAssetsVo) {
    try {
      MemberInfoAssetsVo current = this.memberInfoAssetsService.create(memberInfoAssetsVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param memberInfoAssetsVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<MemberInfoAssetsVo> update(@RequestBody MemberInfoAssetsVo memberInfoAssetsVo) {
    try {
      MemberInfoAssetsVo current = this.memberInfoAssetsService.update(memberInfoAssetsVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.memberInfoAssetsService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.memberInfoAssetsService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.memberInfoAssetsService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
