package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecordDetail;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordVo;
import com.biz.crm.member.business.member.local.service.MemberInfoComeBackRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员退货记录(MemberInfoComeBackRecord)表控制层
 *
 * @author zouhs
 * @date 2023-06-28 16:56:23
 */
@Slf4j
@Api(tags = "会员退货记录")
@RestController
@RequestMapping(value = {"/v1/memberInfoComeBackRecord/memberInfoComeBackRecord"})
public class MemberInfoComeBackRecordController {

  @Autowired(required = false)
  private MemberInfoComeBackRecordService memberInfoComeBackRecordService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoComeBackRecordVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      MemberInfoComeBackRecordPaginationDto paginationDto) {
    try {
      Page<MemberInfoComeBackRecordVo> result = this.memberInfoComeBackRecordService
          .findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("退货明细详情")
  @GetMapping("/come/back/detail")
  public Result<List<MemberInfoComeBackRecordDetailVo>> findDetailByComeBackCode(
      @RequestParam("comeBackCode") String comeBackCode) {
    try {
      List<MemberInfoComeBackRecordDetailVo> result = this.memberInfoComeBackRecordService.findDetailByComeBackCode(comeBackCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<MemberInfoComeBackRecordVo> findDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoComeBackRecordVo memberInfoComeBackRecordVo = this.memberInfoComeBackRecordService
          .findDetailById(id);
      return Result.ok(memberInfoComeBackRecordVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param memberInfoComeBackRecordVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<MemberInfoComeBackRecordVo> create(
      @RequestBody MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
    try {
      MemberInfoComeBackRecordVo current = this.memberInfoComeBackRecordService
          .create(memberInfoComeBackRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param memberInfoComeBackRecordVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<MemberInfoComeBackRecordVo> update(
      @RequestBody MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
    try {
      MemberInfoComeBackRecordVo current = this.memberInfoComeBackRecordService
          .update(memberInfoComeBackRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.memberInfoComeBackRecordService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.memberInfoComeBackRecordService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.memberInfoComeBackRecordService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
