package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAllVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员信息(MemberInfo)表控制层
 *
 * @author zouhs
 * @date 2023-06-19 14:31:58
 */
@Slf4j
@Api(tags = "会员信息")
@RestController
@RequestMapping(value = {"/v1/memberInfo/memberInfo"})
public class MemberInfoController {

  @Autowired(required = false)
  private MemberInfoService memberInfoService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      MemberInfoPaginationDto paginationDto) {
    try {
      Page<MemberInfoVo> result = this.memberInfoService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 审批通过
   *
   * @param memberInfoVo
   * @return
   */
  @ApiOperation(value = "审批通过")
  @PostMapping(value = "approvalPass")
  public Result approvalPass(@RequestBody MemberInfoVo memberInfoVo) {
    try {
      this.memberInfoService.approvalPass(memberInfoVo);
      return Result.ok("审批通过");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 审批驳回
   *
   * @param memberInfoVo
   * @return
   */
  @ApiOperation(value = "审批驳回")
  @PostMapping(value = "approvalReject")
  public Result approvalReject(@RequestBody MemberInfoVo memberInfoVo) {
    try {
      this.memberInfoService.approvalReject(memberInfoVo);
      return Result.ok("审批驳回");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 维护行业
   *
   * @param memberInfoVo
   * @return
   */
  @ApiOperation(value = "维护行业")
  @PostMapping(value = "maintainIndustry")
  public Result maintainIndustry(@RequestBody MemberInfoVo memberInfoVo) {
    try {
      this.memberInfoService.maintainIndustry(memberInfoVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 维护部门
   *
   * @param memberInfoVo
   * @return
   */
  @ApiOperation(value = "维护部门")
  @PostMapping(value = "maintainDepartment")
  public Result maintainDepartment(@RequestBody MemberInfoVo memberInfoVo) {
    try {
      this.memberInfoService.maintainDepartment(memberInfoVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 基础资料
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "基础资料")
  @GetMapping(value = {"/findAllDetailById"})
  public Result<MemberInfoAllVo> findAllDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoAllVo memberInfoAllVo = this.memberInfoService.findAllDetailById(id);
      return Result.ok(memberInfoAllVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 会员资产
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "会员资产")
  @GetMapping(value = {"/findAssetsDetailById"})
  public Result<MemberInfoAssetsVo> findAssetsDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoAssetsVo memberInfoAssetsVo = this.memberInfoService.findAssetsDetailById(id);
      return Result.ok(memberInfoAssetsVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改积分
   *
   * @param memberInfoIntegralRecordVo
   * @return
   */
  @ApiOperation(value = "修改积分")
  @PostMapping(value = "updateIntegral")
  public Result updateIntegral(@RequestBody MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
    try {
      this.memberInfoService.updateIntegral(memberInfoIntegralRecordVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改成长值
   *
   * @param memberInfoGrowRecordVo
   * @return
   */
  @ApiOperation(value = "修改成长值")
  @PostMapping(value = "updateGrow")
  public Result updateGrow(@RequestBody MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    try {
      this.memberInfoService.updateGrow(memberInfoGrowRecordVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<MemberInfoVo> findDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoVo memberInfoVo = this.memberInfoService.findDetailById(id);
      return Result.ok(memberInfoVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param memberInfoVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<MemberInfoVo> create(@RequestBody MemberInfoVo memberInfoVo) {
    try {
      MemberInfoVo current = this.memberInfoService.create(memberInfoVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param memberInfoVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<MemberInfoVo> update(@RequestBody MemberInfoVo memberInfoVo) {
    try {
      MemberInfoVo current = this.memberInfoService.update(memberInfoVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.memberInfoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.memberInfoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.memberInfoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
