package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.local.service.MemberInfoGrowRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoGrowRecordPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员成长值变动记录(MemberInfoGrowRecord)表控制层
 *
 * @author zouhs
 * @date 2023-06-19 14:33:37
 */
@Slf4j
@Api(tags = "会员成长值变动记录")
@RestController
@RequestMapping(value = {"/v1/memberInfoGrowRecord/memberInfoGrowRecord"})
public class MemberInfoGrowRecordController {

  @Autowired(required = false)
  private MemberInfoGrowRecordService memberInfoGrowRecordService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoGrowRecordVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      MemberInfoGrowRecordPaginationDto paginationDto) {
    try {
      Page<MemberInfoGrowRecordVo> result = this.memberInfoGrowRecordService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<MemberInfoGrowRecordVo> findDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoGrowRecordVo memberInfoGrowRecordVo = this.memberInfoGrowRecordService.findDetailById(id);
      return Result.ok(memberInfoGrowRecordVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param memberInfoGrowRecordVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<MemberInfoGrowRecordVo> create(@RequestBody MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    try {
      MemberInfoGrowRecordVo current = this.memberInfoGrowRecordService.create(memberInfoGrowRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param memberInfoGrowRecordVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<MemberInfoGrowRecordVo> update(@RequestBody MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    try {
      MemberInfoGrowRecordVo current = this.memberInfoGrowRecordService.update(memberInfoGrowRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.memberInfoGrowRecordService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.memberInfoGrowRecordService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.memberInfoGrowRecordService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
