package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberIntegralCountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员积分变动记录(MemberInfoIntegralRecord)表控制层
 *
 * @author zouhs
 * @date 2023-06-19 14:34:02
 */
@Slf4j
@Api(tags = "会员积分变动记录")
@RestController
@RequestMapping(value = {"/v1/memberInfoIntegralRecord/memberInfoIntegralRecord"})
public class MemberInfoIntegralRecordController {

  @Autowired(required = false)
  private MemberInfoIntegralRecordService memberInfoIntegralRecordService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoIntegralRecordVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      MemberInfoIntegralRecordPaginationDto paginationDto) {
    try {
      Page<MemberInfoIntegralRecordVo> result = this.memberInfoIntegralRecordService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("积分记录统计")
  @GetMapping("/count/integral/record")
  public Result<MemberIntegralCountVo> countIntegralRecord(){
    try {
      MemberIntegralCountVo result = this.memberInfoIntegralRecordService.countIntegralRecord();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<MemberInfoIntegralRecordVo> findDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoIntegralRecordVo memberInfoIntegralRecordVo = this.memberInfoIntegralRecordService.findDetailById(id);
      return Result.ok(memberInfoIntegralRecordVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param memberInfoIntegralRecordVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<MemberInfoIntegralRecordVo> create(@RequestBody MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
    try {
      MemberInfoIntegralRecordVo current = this.memberInfoIntegralRecordService.create(memberInfoIntegralRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param memberInfoIntegralRecordVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<MemberInfoIntegralRecordVo> update(@RequestBody MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
    try {
      MemberInfoIntegralRecordVo current = this.memberInfoIntegralRecordService.update(memberInfoIntegralRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.memberInfoIntegralRecordService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.memberInfoIntegralRecordService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.memberInfoIntegralRecordService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
