package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordVo;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员签收记录(MemberInfoReceiptRecord)表控制层
 *
 * @author zouhs
 * @date 2023-06-28 16:55:37
 */
@Slf4j
@Api(tags = "会员签收记录")
@RestController
@RequestMapping(value = {"/v1/memberInfoReceiptRecord/memberInfoReceiptRecord"})
public class MemberInfoReceiptRecordController {

  @Autowired(required = false)
  private MemberInfoReceiptRecordService memberInfoReceiptRecordService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoReceiptRecordVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      MemberInfoReceiptRecordPaginationDto paginationDto) {
    try {
      Page<MemberInfoReceiptRecordVo> result = this.memberInfoReceiptRecordService
          .findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("获取签收明细，展示商品名称以及数量")
  @GetMapping("/find/detail")
  public Result<List<MemberInfoReceiptRecordDetailVo>> findDetailByReceiptCode(
      @RequestParam("receiptCode") String receiptCode) {
    try {
      List<MemberInfoReceiptRecordDetailVo> result = this.memberInfoReceiptRecordService.findDetailByReceiptCode(receiptCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<MemberInfoReceiptRecordVo> findDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoReceiptRecordVo memberInfoReceiptRecordVo = this.memberInfoReceiptRecordService
          .findDetailById(id);
      return Result.ok(memberInfoReceiptRecordVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param memberInfoReceiptRecordVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<MemberInfoReceiptRecordVo> create(
      @RequestBody MemberInfoReceiptRecordVo memberInfoReceiptRecordVo) {
    try {
      MemberInfoReceiptRecordVo current = this.memberInfoReceiptRecordService
          .create(memberInfoReceiptRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param memberInfoReceiptRecordVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<MemberInfoReceiptRecordVo> update(
      @RequestBody MemberInfoReceiptRecordVo memberInfoReceiptRecordVo) {
    try {
      MemberInfoReceiptRecordVo current = this.memberInfoReceiptRecordService
          .update(memberInfoReceiptRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.memberInfoReceiptRecordService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.memberInfoReceiptRecordService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.memberInfoReceiptRecordService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
