package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoTagVo;
import com.biz.crm.member.business.member.local.service.MemberInfoTagService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoTagPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberLabelUpdVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员标签(MemberInfoTag)表控制层
 *
 * @author zouhs
 * @date 2023-06-19 14:35:01
 */
@Slf4j
@Api(tags = "会员标签")
@RestController
@RequestMapping(value = {"/v1/memberInfoTag/memberInfoTag"})
public class MemberInfoTagController {

  @Autowired(required = false)
  private MemberInfoTagService memberInfoTagService;


  /**
   * 编辑保存更新标签
   *
   * @param memberLabelUpdVo
   * @return
   */
  @ApiOperation(value = "编辑保存更新标签")
  @PostMapping(value = "memberLabelUpd")
  public Result memberLabelUpd(@RequestBody MemberLabelUpdVo memberLabelUpdVo) {
    try {
      this.memberInfoTagService.memberLabelUpd(memberLabelUpdVo);
      return Result.ok("编辑成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 会员标签
   *
   * @param memberCode
   * @return
   */
  @ApiOperation(value = "会员标签")
  @GetMapping(value = "queryMemberLabel")
  public Result<List<MemberInfoTagVo>> queryMemberLabel(@RequestParam("memberCode") String memberCode) {
    try {
      List<MemberInfoTagVo> list = this.memberInfoTagService.queryMemberLabel(memberCode);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }



  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoTagVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      MemberInfoTagPaginationDto paginationDto) {
    try {
      Page<MemberInfoTagVo> result = this.memberInfoTagService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<MemberInfoTagVo> findDetailById(@RequestParam("id") String id) {
    try {
      MemberInfoTagVo memberInfoTagVo = this.memberInfoTagService.findDetailById(id);
      return Result.ok(memberInfoTagVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param memberInfoTagVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<MemberInfoTagVo> create(@RequestBody MemberInfoTagVo memberInfoTagVo) {
    try {
      MemberInfoTagVo current = this.memberInfoTagService.create(memberInfoTagVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param memberInfoTagVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<MemberInfoTagVo> update(@RequestBody MemberInfoTagVo memberInfoTagVo) {
    try {
      MemberInfoTagVo current = this.memberInfoTagService.update(memberInfoTagVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.memberInfoTagService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.memberInfoTagService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.memberInfoTagService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
