package com.biz.crm.member.business.member.local.controller;

import cn.hutool.core.lang.Dict;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.MessageManageService;
import com.biz.crm.member.business.member.sdk.dto.MessageManageDto;
import com.biz.crm.member.business.member.sdk.dto.MessageManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.MessageManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 消息管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 14:46
 **/
@Slf4j
@Api(tags = "消息/弹窗管理")
@RestController
@RequestMapping(value = {"/v1/member/message"})
public class MessageManageController {

    @Autowired
    private MessageManageService messageManageService;


    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<MessageManagePageVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                              MessageManagePageDto pageDto) {
        try {
            Page<MessageManagePageVo> result = this.messageManageService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<MessageManageVo> findDetailById(@RequestParam("id") String id) {
        try {
            MessageManageVo messageManageVo = this.messageManageService.findDetailById(id);
            return Result.ok(messageManageVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param messageManageDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<MessageManageVo> create(@RequestBody MessageManageDto messageManageDto) {
        try {
            MessageManageVo current = this.messageManageService.create(messageManageDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<MessageManageVo> update(@RequestBody MessageManageDto messageManageDto) {
        try {
            MessageManageVo current = this.messageManageService.update(messageManageDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.messageManageService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.messageManageService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.messageManageService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据触发类型查询触发条件
     *
     * @param id
     * @return
     */
//    @ApiOperation(value = "详情")
//    @GetMapping(value = {"/findDetailById"})
//    public Result<MessageManageVo> findDetailById(@RequestParam("id") String id) {
//        try {
//            MessageManageVo messageManageVo = this.messageManageService.findDetailById(id);
//            return Result.ok(messageManageVo);
//        } catch (RuntimeException e) {
//            log.error(e.getMessage(), e);
//            return Result.error(e.getMessage());
//        }
//    }

}
