package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.PrizeService;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.dto.PrizeDto;
import com.biz.crm.member.business.member.sdk.dto.PrizeDto;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 奖品控制器
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 14:31
 **/
@Api(tags = "奖品管理")
@Slf4j
@RestController
@RequestMapping("/v1/member/prize")
public class PrizeController {

    @Autowired
    private PrizeService prizeService;
    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<PrizeVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                  PrizeDto pageDto) {
        try {
            Page<PrizeVo> result = this.prizeService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<PrizeVo> findDetailById(@RequestParam(value = "id") String id) {
        try {
            PrizeVo viewpagerVo = this.prizeService.findDetailById(id);
            return Result.ok(viewpagerVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<PrizeVo> create(@RequestBody PrizeDto prizeDto) {
        try {
            PrizeVo current = this.prizeService.create(prizeDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<PrizeVo> update(@RequestBody PrizeDto viewpagerDto) {
        try {
            PrizeVo current = this.prizeService.update(viewpagerDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.prizeService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.prizeService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.prizeService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 调整数量
     * @param id
     * @param number
     * @return
     */
    @ApiOperation(value = "调整数量")
    @GetMapping("/adjust")
    public Result adjust (@RequestParam("id") String id,@RequestParam("number") BigDecimal number) {

        try {
            this.prizeService.adjust(id,number);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }
}
