package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ProductCategoryService;
import com.biz.crm.member.business.member.sdk.dto.ProductCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.vo.ProductCategoryVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商品分类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/14 16:29
 **/
@Slf4j
@Api(tags = "商品分类")
@RestController
@RequestMapping("/v1/member/productCategory")
public class ProductCategoryController extends BaseController {

    @Autowired
    private ProductCategoryService productCategoryService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<ProductCategoryVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                            ProductCategoryDto pageDto) {
        try {
            Page<ProductCategoryVo> result = this.productCategoryService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<ProductCategoryVo> findDetailById(@RequestParam("id") String id) {
        try {
            ProductCategoryVo productCategoryVo = this.productCategoryService.findDetailById(id);
            return Result.ok(productCategoryVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param productCategoryDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<ProductCategoryVo> create(@RequestBody ProductCategoryDto productCategoryDto) {
        try {
            ProductCategoryVo current = this.productCategoryService.create(productCategoryDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<ProductCategoryVo> update(@RequestBody ProductCategoryDto productCategoryDto) {
        try {
            ProductCategoryVo current = this.productCategoryService.update(productCategoryDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.productCategoryService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.productCategoryService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.productCategoryService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 上移
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "上移")
    @PatchMapping(value = "/up")
    public Result up(@RequestParam("id") String id) {
        try {
            this.productCategoryService.up(id);
            return Result.ok("上移成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 下移
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "下移")
    @PatchMapping(value = "/down")
    public Result down(@RequestParam("id") String id) {
        try {
            this.productCategoryService.down(id);
            return Result.ok("下移成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
