package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ProductService;
import com.biz.crm.member.business.member.sdk.dto.ProductDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品信息控制层
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 16:20
 **/
@Slf4j
@Api(tags = "商品")
@RestController
@RequestMapping("/v1/member/product")
public class ProductController extends BaseController {

    @Autowired
    private ProductService productService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<ProductPageVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                        ProductPageDto pageDto) {
        try {
            Page<ProductPageVo> result = this.productService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<ProductVo> findDetailById(@RequestParam("id") String id) {
        try {
            ProductVo productVo = this.productService.findDetailById(id);
            return Result.ok(productVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param productDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<ProductVo> create(@RequestBody ProductDto productDto) {
        try {
            ProductVo current = this.productService.create(productDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<ProductVo> update(@RequestBody ProductDto productDto) {
        try {
            ProductVo current = this.productService.update(productDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.productService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.productService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量上架
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量上架")
    @PatchMapping(value = "/shelfUp")
    public Result shelfUp(@RequestBody List<String> ids) {
        try {
            this.productService.shelfUp(ids);
            return Result.ok("上架成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量下架
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量下架")
    @PatchMapping(value = "/shelfDown")
    public Result shelfDown(@RequestBody List<String> ids) {
        try {
            this.productService.shelfDown(ids);
            return Result.ok("下架成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.productService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 调整数量
     * @param id
     * @param number
     * @return
     */
    @ApiOperation(value = "调整数量")
    @GetMapping("/adjust")
    public Result adjust (@RequestParam("id") String id,@RequestParam("number") BigDecimal number) {

        try {
            this.productService.adjust(id, number);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    }
