package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.QuestionnaireService;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnairePaginationDto;
import com.biz.crm.member.business.member.sdk.enums.QuestionnaireStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionAnswerVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireAnalyzeVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireDetailVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 14:49
 * @description 问卷管理
 */
@Api(tags = "问卷管理")
@Slf4j
@RequestMapping("/v1/questionnaire/manage")
@RestController
public class QuestionnaireController {

  @Autowired
  private QuestionnaireService questionnaireService;


  @ApiOperation("新增(暂不发布)")
  @PostMapping("/create/questionnaire")
  public Result<QuestionnaireVo> createQuestionnaire(@RequestBody QuestionDto dto) {
    try {
      QuestionnaireVo result = questionnaireService.createQuestionnaire(dto,
          QuestionnaireStatusEnum.NO_PUBLISH);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("新增(发布)")
  @PostMapping("/create/questionnaire/publish")
  public Result<QuestionnaireVo> createQuestionnairePublish(@RequestBody QuestionDto dto) {
    try {
      QuestionnaireVo result = questionnaireService.createQuestionnairePublish(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("分页获取问卷")
  @GetMapping("/page")
  public Result<Page<QuestionnaireVo>> pageResult(@PageableDefault(50) Pageable pageable,
      QuestionnairePaginationDto dto) {
    try {
      Page<QuestionnaireVo> result = this.questionnaireService.pageResult(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("删除")
  @DeleteMapping("/delete")
  public Result logicDeleteQuestionnaire(@RequestParam("ids") List<String> ids) {
    try {
      this.questionnaireService.logicDelete(ids);
      return Result.ok("删除成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("启用")
  @PatchMapping("/turn/on")
  public Result turnOnQuestionnaire(@RequestBody List<String> ids) {
    try {
      this.questionnaireService.turnOnQuestionnaire(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("禁用")
  @PatchMapping("/turn/off")
  public Result turnOffQuestionnaire(@RequestBody List<String> ids) {
    try {
      this.questionnaireService.turnOffQuestionnaire(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("发布问卷")
  @GetMapping("/publish")
  public Result publishQuestionnaire(@RequestParam("questionnaireCode") String questionnaireCode) {
    try {
      this.questionnaireService.publishQuestionnaire(questionnaireCode);
      return Result.ok("发布成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("结束问卷")
  @GetMapping("/finish")
  public Result finishQuestionnaire(@RequestParam("questionnaireCode") String questionnaireCode) {
    try {
      this.questionnaireService.finishQuestionnaire(questionnaireCode);
      return Result.ok("结束问卷成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "获取问卷详情", notes = "根据问卷编码获取问卷详情，详情包括问卷基本信息和问卷题目配置信息等")
  @GetMapping("/questionnaire/detail/{code}")
  public Result<QuestionnaireDetailVo> getQuestionnaireDetail(
      @PathVariable("code") String questionnaireCode) {
    try {
      QuestionnaireDetailVo result = this.questionnaireService
          .getQuestionnaireDetailByCode(questionnaireCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("编辑问卷")
  @PostMapping("/modify/questionnarie")
  public Result<QuestionnaireVo> modifyQuestionnaire(@RequestBody QuestionDto dto) {
    try {
      QuestionnaireVo result = this.questionnaireService.modifyQuestionnaire(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("复制")
  @GetMapping("/questionnaire/copy/{code}")
  public Result<QuestionnaireVo> copyQuestionnaireByCode(
      @PathVariable("code") String questionnaireCode) {
    try {
      QuestionnaireVo result = this.questionnaireService.copyQuestionnaireByCode(questionnaireCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("问卷分析")
  @GetMapping("/questionnaire/analyze")
  public Result<List<QuestionnaireAnalyzeVo>> getQuestionnaireAnalyze(
      @RequestParam("questionnaireCode") String questionnaireCode) {
    try {
      List<QuestionnaireAnalyzeVo> result = this.questionnaireService
          .getQuestionnaireAnalyze(questionnaireCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("分页查看题目详情")
  @GetMapping("/page/question/detail")
  public Result<Page<AnswerRecordVo>> pageQuestionDetail(@PageableDefault(50) Pageable pageable,
      AnswerRecordPaginationDto dto) {
    try {
      Page<AnswerRecordVo> result = this.questionnaireService.pageQuestionDetail(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("查看答卷")
  @GetMapping("/view/question/answer")
  public Result<List<QuestionAnswerVo>> getQuestionAnswer(
      @RequestParam("questionnaireCode") String questionnaireCode,
      @RequestParam("memberCode") String memberCode) {
    try {
      List<QuestionAnswerVo> result = this.questionnaireService
          .getQuestionAnswer(questionnaireCode, memberCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
