package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.PrizeService;
import com.biz.crm.member.business.member.local.service.RaffleManageService;
import com.biz.crm.member.business.member.sdk.dto.RaffleManageDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.RaffleManageVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleManagePageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 大转盘管理控制器
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 15:58
 **/
@Api(tags = "大转盘管理")
@Slf4j
@RestController
@RequestMapping("/v1/member/raffle")
public class RaffleManageController {

    @Autowired
    private RaffleManageService raffleManageService;
    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<RaffleManagePageVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             RaffleManagePageDto pageDto) {
        try {
            Page<RaffleManagePageVo> result = this.raffleManageService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<RaffleManageVo> findDetailById(@RequestParam(value = "id",required = false) String id,
                                                 @RequestParam(value = "code",required = false) String code) {
        try {
            RaffleManageVo viewpagerVo = this.raffleManageService.findDetailById(id,null);
            return Result.ok(viewpagerVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<RaffleManageVo> create(@RequestBody RaffleManageDto raffleManageDto) {
        try {
            RaffleManageVo current = this.raffleManageService.create(raffleManageDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<RaffleManageVo> update(@RequestBody RaffleManageDto raffleManageDto) {
        try {
            RaffleManageVo current = this.raffleManageService.update(raffleManageDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.raffleManageService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.raffleManageService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.raffleManageService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
