package com.biz.crm.member.business.member.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.RafflePrizeService;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * 大转盘奖项管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 15:39
 **/
@Api(tags = "大转盘奖项管理")
@Slf4j
@RestController
@RequestMapping("/v1/member/rafflePrize")
public class RafflePrizeController {

    @Autowired
    private RafflePrizeService rafflePrizeService;


    @ApiOperation(value = "大转盘奖品数量调整")
    @GetMapping("/adjust")
    public Result adjust (@RequestParam("detailId") String detailId,@RequestParam("number") BigDecimal number) {

        try {
             this.rafflePrizeService.adjust(detailId,number);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }

    @ApiOperation(value = "删除奖项")
    @GetMapping("/delete")
    public Result delete (@RequestParam("id") String id) {

        try {
            this.rafflePrizeService.delete(id);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }
}
