package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.RafflePrizeRecordService;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 大转盘中奖记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 14:07
 **/
@Api(tags = "大转盘中奖记录")
@Slf4j
@RestController
@RequestMapping("/v1/member/raffle/prize/record")
public class RafflePrizeRecordController {
    
    @Autowired
    private RafflePrizeRecordService rafflePrizeRecordService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "(后台)查询中奖记录分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<RafflePrizeRecordVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                              RafflePrizeRecordDto pageDto) {
        try {
            Page<RafflePrizeRecordVo> result = this.rafflePrizeRecordService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "(小程序)查询中奖记录分页列表")
    @GetMapping(value = {"/findByConditionsByApplet"})
    public Result<Page<RafflePrizeRecordVo>> findByConditionsByApplet(@PageableDefault(50) Pageable pageable,
                                                              RafflePrizeRecordDto pageDto) {
        try {
            Page<RafflePrizeRecordVo> result = this.rafflePrizeRecordService.findByConditionsByApplet(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<RafflePrizeRecordVo> findDetailById(@RequestParam(value = "id",required = false) String id,
                                                      @RequestParam(value = "code",required = false) String code) {
        try {
            RafflePrizeRecordVo viewpagerVo = this.rafflePrizeRecordService.findDetailById(id,code);
            return Result.ok(viewpagerVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<RafflePrizeRecordVo> create(@RequestBody RafflePrizeRecordDto rafflePrizeRecordDto) {
        try {
            RafflePrizeRecordVo current = this.rafflePrizeRecordService.create(rafflePrizeRecordDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<RafflePrizeRecordVo> update(@RequestBody RafflePrizeRecordDto rafflePrizeRecordDto) {
        try {
            RafflePrizeRecordVo current = this.rafflePrizeRecordService.update(rafflePrizeRecordDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.rafflePrizeRecordService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.rafflePrizeRecordService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.rafflePrizeRecordService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
