package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.sdk.dto.RealAndDummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.RealOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.RealAndDummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderDistributeVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员实物和虚拟订单
 *
 * @author zouhs
 * @date 2023-06-14 14:53:18
 */
@Slf4j
@Api(tags = "会员实物和虚拟订单")
@RestController
@RequestMapping(value = {"/v1/realAndOrder/realAndOrder"})
public class RealAndDummyOrderController {

  @Autowired(required = false)
  private RealOrderService realOrderService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditionsRealAndOrder"})
  public Result<Page<RealAndDummyOrderVo>> findByConditionsRealAndOrder(@PageableDefault(50) Pageable pageable,
      RealAndDummyOrderPaginationDto paginationDto) {
    try {
      Page<RealAndDummyOrderVo> result = this.realOrderService.findByConditionsRealAndOrder(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
