package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.RealOrderDistributeVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.sdk.dto.RealOrderPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 实物订单(RealOrder)表控制层
 *
 * @author zouhs
 * @date 2023-06-14 14:53:18
 */
@Slf4j
@Api(tags = "实物订单")
@RestController
@RequestMapping(value = {"/v1/realOrder/realOrder"})
public class RealOrderController {

  @Autowired(required = false)
  private RealOrderService realOrderService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<RealOrderVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      RealOrderPaginationDto paginationDto) {
    try {
      Page<RealOrderVo> result = this.realOrderService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 转为总部订单
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "转为总部订单")
  @PostMapping("/changeTotalOrder")
  public Result changeTotalOrder(@RequestBody List<String> ids) {
    try {
      this.realOrderService.changeTotalOrder(ids);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 转为市场配送订单
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "转为市场配送订单")
  @PostMapping("/changeMarketOrder")
  public Result changeMarketOrder(@RequestBody List<String> ids) {
    try {
      this.realOrderService.changeMarketOrder(ids);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 发货
   *
   * @param realOrderVo
   * @return
   */
  @ApiOperation(value = "发货")
  @PostMapping("/shipOrderById")
  public Result shipOrderById(@RequestBody RealOrderVo realOrderVo) {
    try {
      this.realOrderService.shipOrderById(realOrderVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 取消发货
   *
   * @param realOrderVo
   * @return
   */
  @ApiOperation(value = "取消发货")
  @PostMapping("/cancelShipOrderById")
  public Result cancelShipOrderById(@RequestBody RealOrderVo realOrderVo) {
    try {
      this.realOrderService.cancelShipOrderById(realOrderVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分发
   *
   * @param realOrderDistributeVo
   * @return
   */
  @ApiOperation(value = "分发")
  @PostMapping("/changeDistribute")
  public Result changeDistribute(@RequestBody RealOrderDistributeVo realOrderDistributeVo) {
    try {
      this.realOrderService.changeDistribute(realOrderDistributeVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 结算 - 提交工作流
   *
   * @param realOrderVo
   * @return
   */
  @ApiOperation(value = "结算 - 提交工作流")
  @PostMapping("/settleSubmit")
  public Result settleSubmit(@RequestBody RealOrderVo realOrderVo) {
    try {
      this.realOrderService.settleSubmit(realOrderVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<RealOrderVo> findDetailById(@RequestParam("id") String id) {
    try {
      RealOrderVo realOrderVo = this.realOrderService.findDetailById(id);
      return Result.ok(realOrderVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param realOrderVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<RealOrderVo> create(@RequestBody RealOrderVo realOrderVo) {
    try {
      RealOrderVo current = this.realOrderService.create(realOrderVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param realOrderVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<RealOrderVo> update(@RequestBody RealOrderVo realOrderVo) {
    try {
      RealOrderVo current = this.realOrderService.update(realOrderVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.realOrderService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.realOrderService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.realOrderService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
