package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ScenicSpotsManagementService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.ScenicAreaManagementVo;
import com.biz.crm.member.business.member.sdk.vo.ScenicSpotsManagementVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 景点管理
 *
 * @author hupan
 * @date 2023/6/20 10:59
 */
@Slf4j
@Api(tags = "景点管理")
@RestController
@RequestMapping(value = {"/v1/scenicSpotsManagement/scenicSpotsManagement"})
public class ScenicSpotsManagementController {

  @Autowired
  private ScenicSpotsManagementService scenicSpotsManagementService;

  /**
   * 根据景区id查询所有景点
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "根据景区id查询所有景点")
  @GetMapping(value = {"/findByScenicId"})
  public Result<List<ScenicSpotsManagementVo>> findByScenicId(@RequestParam("id") String id) {
    try {
      log.info("==============id为=====>>>>>{}",id);
      List<ScenicSpotsManagementVo> result = this.scenicSpotsManagementService.findByScenicId(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param scenicSpotsManagementVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<ScenicSpotsManagementVo> create(@RequestBody ScenicSpotsManagementVo scenicSpotsManagementVo) {
    try {
      ScenicSpotsManagementVo current = this.scenicSpotsManagementService.create(scenicSpotsManagementVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param scenicSpotsManagementVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<ScenicSpotsManagementVo> update(@RequestBody ScenicSpotsManagementVo scenicSpotsManagementVo) {
    try {
      ScenicSpotsManagementVo current = this.scenicSpotsManagementService.update(scenicSpotsManagementVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
