package com.biz.crm.member.business.member.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.SignInRuleService;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 签到规则(SignInRule)表控制层
 *
 * @author zouhs
 * @date 2023-06-15 16:47:20
 */
@Slf4j
@Api(tags = "签到规则")
@RestController
@RequestMapping(value = {"/v1/signInRule/signInRule"})
public class SignInRuleController {

  @Autowired(required = false)
  private SignInRuleService signInRuleService;

  /**
   * 获取默认一条规则
   *
   * @return
   */
  @ApiOperation(value = "获取默认一条规则")
  @GetMapping(value = {"/findDetail"})
  public Result<SignInRuleVo> findDetail() {
    try {
      SignInRuleVo signInRuleVo = this.signInRuleService.findDetail();
      return Result.ok(signInRuleVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param signInRuleVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<SignInRuleVo> update(@RequestBody SignInRuleVo signInRuleVo) {
    try {
      SignInRuleVo current = this.signInRuleService.update(signInRuleVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

//  /**
//   * 详情
//   *
//   * @param id
//   * @return
//   */
//  @ApiOperation(value = "详情")
//  @GetMapping(value = {"/findDetailById"})
//  public Result<SignInRuleVo> findDetailById(String id) {
//    try {
//      SignInRuleVo signInRuleVo = this.signInRuleService.findDetailById(id);
//      return Result.ok(signInRuleVo);
//    } catch (RuntimeException e) {
//      log.error(e.getMessage(), e);
//      return Result.error(e.getMessage());
//    }
//  }

//
//  /**
//   * 查询分页列表
//   *
//   * @param pageable
//   * @param paginationDto
//   * @return
//   */
//  @ApiOperation(value = "查询分页列表")
//  @GetMapping(value = {"/findByConditions"})
//  public Result<Page<SignInRuleVo>> findByConditions(@PageableDefault(50) Pageable pageable,
//      SignInRulePaginationDto paginationDto) {
//    try {
//      Page<SignInRuleVo> result = this.signInRuleService.findByConditions(pageable, paginationDto);
//      return Result.ok(result);
//    } catch (RuntimeException e) {
//      log.error(e.getMessage(), e);
//      return Result.error(e.getMessage());
//    }
//  }
//
//
//
//  /**
//   * 创建
//   *
//   * @param signInRuleVo
//   * @return
//   */
//  @ApiOperation(value = "创建")
//  @PostMapping(value = "")
//  public Result<SignInRuleVo> create(@RequestBody SignInRuleVo signInRuleVo) {
//    try {
//      SignInRuleVo current = this.signInRuleService.create(signInRuleVo);
//      return Result.ok(current);
//    } catch (RuntimeException e) {
//      log.error(e.getMessage(), e);
//      return Result.error(e.getMessage());
//    }
//  }
//
//
//
//  /**
//   * 启用
//   *
//   * @param ids
//   * @return
//   */
//  @ApiOperation(value = "启用")
//  @PatchMapping("/enable")
//  public Result enable(@RequestBody List<String> ids) {
//    try {
//      this.signInRuleService.enableBatch(ids);
//      return Result.ok("启用成功");
//    } catch (RuntimeException e) {
//      log.error(e.getMessage(), e);
//      return Result.error(e.getMessage());
//    }
//  }
//
//  /**
//   * 禁用
//   *
//   * @param ids
//   * @return
//   */
//  @ApiOperation(value = "禁用")
//  @PatchMapping("/disable")
//  public Result disable(@RequestBody List<String> ids) {
//    try {
//      this.signInRuleService.disableBatch(ids);
//      return Result.ok("禁用成功");
//    } catch (RuntimeException e) {
//      log.error(e.getMessage(), e);
//      return Result.error(e.getMessage());
//    }
//  }
//
//  /**
//   * 逻辑删除
//   *
//   * @param ids
//   * @return
//   */
//  @ApiOperation(value = "逻辑删除")
//  @DeleteMapping("/delete")
//  public Result delete(@RequestParam("ids") List<String> ids) {
//    try {
//      this.signInRuleService.updateDelFlagByIds(ids);
//      return Result.ok("删除成功");
//    } catch (RuntimeException e) {
//      log.error(e.getMessage(), e);
//      return Result.error(e.getMessage());
//    }
//  }
}
