package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleDetailVo;
import com.biz.crm.member.business.member.local.service.SignInRuleDetailService;
import com.biz.crm.member.business.member.sdk.dto.SignInRuleDetailPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 签到规则明细(SignInRuleDetail)表控制层
 *
 * @author zouhs
 * @date 2023-06-15 16:47:45
 */
@Slf4j
@Api(tags = "签到规则明细")
@RestController
@RequestMapping(value = {"/v1/signInRuleDetail/signInRuleDetail"})
public class SignInRuleDetailController {

  @Autowired(required = false)
  private SignInRuleDetailService signInRuleDetailService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<SignInRuleDetailVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      SignInRuleDetailPaginationDto paginationDto) {
    try {
      Page<SignInRuleDetailVo> result = this.signInRuleDetailService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<SignInRuleDetailVo> findDetailById(@RequestParam("id") String id) {
    try {
      SignInRuleDetailVo signInRuleDetailVo = this.signInRuleDetailService.findDetailById(id);
      return Result.ok(signInRuleDetailVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param signInRuleDetailVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<SignInRuleDetailVo> create(@RequestBody SignInRuleDetailVo signInRuleDetailVo) {
    try {
      SignInRuleDetailVo current = this.signInRuleDetailService.create(signInRuleDetailVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param signInRuleDetailVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<SignInRuleDetailVo> update(@RequestBody SignInRuleDetailVo signInRuleDetailVo) {
    try {
      SignInRuleDetailVo current = this.signInRuleDetailService.update(signInRuleDetailVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.signInRuleDetailService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.signInRuleDetailService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.signInRuleDetailService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
