package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.SystemSettingsService;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismTopicPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsReservedVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统设置
 *
 * @author hupan
 * @date 2023/6/21 11:11
 */
@Slf4j
@Api(tags = "系统设置")
@RestController
@RequestMapping(value = {"/v1/systemSettings/systemSettings"})
public class SystemSettingsController {

  @Autowired(required = false)
  private SystemSettingsService systemSettingsService;
  @Autowired
  private SystemSettingsDetailService systemSettingsDetailService;

  /**
   * 查询所有数据
   *
   * @return
   */
  @ApiOperation(value = "查询所有数据")
  @GetMapping(value = {"/findAll"})
  public Result<List<SystemSettingsVo>> findByConditions() {
    try {
      List<SystemSettingsVo> result = this.systemSettingsService.findAll();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询权益分类设置
   *
   * @return
   */
  @ApiOperation(value = "查询权益分类设置")
  @GetMapping(value = {"/findBenefitsSetting"})
  public Result<List<SystemSettingsReservedVo>> findBenefitsSetting() {
    try {
      List<SystemSettingsReservedVo> result = this.systemSettingsService.findReserved();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param systemSettingsDetailVos
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<List<SystemSettingsDetailVo>> update(@RequestBody List<SystemSettingsDetailVo> systemSettingsDetailVos) {
    try {
      List<SystemSettingsDetailVo> current = this.systemSettingsDetailService.update(systemSettingsDetailVos);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
