package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.TaskingAdvisorInviteRecordService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.TaskingAdvisorInviteRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.TaskingAdvisorInviteRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 品鉴顾问邀请记录(TaskingAdvisorInviteRecord)表控制层
 *
 * @author hupan
 * @date 2023/6/29 13:46
 */
@Api(tags = "品鉴顾问邀请记录控制层")
@Slf4j
@RestController
@RequestMapping("/v1/taskingAdvisorInviteRecord/taskingAdvisorInviteRecord")
public class TaskingAdvisorInviteRecordController {

  @Autowired
  private TaskingAdvisorInviteRecordService taskingAdvisorInviteRecordService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<TaskingAdvisorInviteRecordVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      TaskingAdvisorInviteRecordPaginationDto paginationDto) {
    try {
      Page<TaskingAdvisorInviteRecordVo> result = this.taskingAdvisorInviteRecordService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param taskingAdvisorInviteRecordVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<TaskingAdvisorInviteRecordVo> create(@RequestBody TaskingAdvisorInviteRecordVo taskingAdvisorInviteRecordVo) {
    try {
      TaskingAdvisorInviteRecordVo current = this.taskingAdvisorInviteRecordService.create(taskingAdvisorInviteRecordVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
