package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.VerificationUserService;
import com.biz.crm.member.business.member.sdk.dto.VerificationUserDto;
import com.biz.crm.member.business.member.sdk.vo.VerificationUserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 核销-人员管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 16:48
 **/
@Slf4j
@Api(tags = "核销-人员管理")
@RestController
@RequestMapping("/v1/member/verification/user")
public class VerificationUserController {

    @Autowired
    private VerificationUserService verificationUserService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param pageDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<VerificationUserVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             VerificationUserDto pageDto) {
        try {
            Page<VerificationUserVo> result = this.verificationUserService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<VerificationUserVo> findDetailById(@RequestParam("id") String id) {
        try {
            VerificationUserVo verificationUserVo = this.verificationUserService.findDetailById(id);
            return Result.ok(verificationUserVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param verificationUserDto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<VerificationUserVo> create(@RequestBody VerificationUserDto verificationUserDto) {
        try {
            VerificationUserVo current = this.verificationUserService.create(verificationUserDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param verificationUserDto
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<VerificationUserVo> update(@RequestBody VerificationUserDto verificationUserDto) {
        try {
            VerificationUserVo current = this.verificationUserService.update(verificationUserDto);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.verificationUserService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.verificationUserService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @PatchMapping(value = "/delete")
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.verificationUserService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
