package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.AppPointStoreService;
import com.biz.crm.member.business.member.sdk.dto.AppPointStoreDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

@Slf4j
@Api(tags = "小程序积分栏")
@RestController
@RequestMapping("/v1/app/point")
public class AppPointStoreController {

  @Autowired
  AppPointStoreService appPointStoreService;

  /**
   * 商品列表查询
   *
   * @param pageable
   * @param pageDto
   * @return
   */
  @ApiOperation(value = "商品列表查询")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ProductPageVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                      ProductPageDto pageDto) {
    try {
      Page<ProductPageVo> result = this.appPointStoreService.findByConditions(pageable, pageDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<ProductVo> findDetailById(@RequestParam("id") String id) {
    try {
      ProductVo productVo = this.appPointStoreService.findDetailById(id);
      return Result.ok(productVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 积分虚拟商品兑换
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "积分虚拟商品兑换")
  @PostMapping(value = {"/exchangeVirtual"})
  public Result<?> exchangeVirtual(@RequestBody AppPointStoreDto dto) {
    try {
      this.appPointStoreService.exchangeVirtual(dto);
      return Result.ok("兑换成功！");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }




}
